#! /bin/bash

function get_primary_slot {
    max_fail_boot=$(fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --get_max_fail_boot)
    bootorder=$(fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --get_boot_order)
    list=$(echo $bootorder | tr " ")
    for slot in ${list}; do
        fail_boot=$(fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --get_fail_boot_count ${slot})
        if [[ ${fail_boot} -le ${max_fail_boot} ]]; then
            echo $slot
            exit 0
        fi
    done

    exit 1
}

function set_primary_slot {
    fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --set_primary $1
    exit 0
}

function get_boot_state {
    find=0
    bootorder=$(fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --get_boot_order)
    list=$(echo $bootorder | tr " ")
    for slot in ${list}; do
        if [[ "${slot}" = "${1}" ]]; then
            find=1
            break
        fi
    done
    if [[ $find = 0 ]]; then
        echo bad
        exit 1
    fi


    fail_count=$(fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --get_fail_boot_count ${1})
    if [[ $fail_count -gt 3 ]]; then
        echo bad
        exit 1
    fi

    echo good
    exit 0
}

function set_boot_state {
    if [ "$2" == "good" ]; then
        fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --reset_fail_boot_count $1
        exit 0
    fi

    if [ "$2" == "bad" ]; then
        fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --invalidate_slot $1
        exit 0
    fi

    exit 1
}

task=$1
shift

slot=$1
shift

state=$1
shift

# Parse cmdline

BOOTDEVICE=

for opt in $(cat /proc/cmdline); do
    arg=$(echo "$opt" | cut -d'=' -f1)
    if [ "$arg" == "bootloader" ]; then
        BOOTLOADER=$(echo "$opt" | cut -d'=' -f2-)
    elif [ "$arg" == "bootdevice" ]; then
        BOOTDEVICE=$(echo "$opt" | cut -d'=' -f2-)
    fi
done

case $task in

  get-primary)
    get_primary_slot
    ;;

  set-primary)
    set_primary_slot $slot
    ;;

  get-state)
    get_boot_state $slot
    ;;

  set-state)
    set_boot_state $slot $state
    ;;

  *)
    exit 1
    ;;

esac
