#!/bin/sh

FW_ENV_TEMPLATE=/etc/fw_env.config_template
FW_ENV_CONFIG=/etc/fw_env.config

RAUC_TEMPLATE_DIR=/etc/rauc/system.conf.d
RAUC_CONFIG=/etc/rauc/system.conf

BOOTLOADER=
BOOTDEVICE=
LOADER=
DEVICE=

# Parse cmdline

for opt in $(cat /proc/cmdline); do
    arg=$(echo "$opt" | cut -d'=' -f1)
    if [ "$arg" == "bootloader" ]; then
        BOOTLOADER=$(echo "$opt" | cut -d'=' -f2-)
    elif [ "$arg" == "bootdevice" ]; then
        BOOTDEVICE=$(echo "$opt" | cut -d'=' -f2-)
    fi
done

# Validate and set variables

if [[ -z $BOOTLOADER ]]; then
    echo "No bootloader is present on bootargs."
fi

if [[ -z $BOOTDEVICE ]]; then
    echo "No boot device is presents on bootargs."
fi

case $BOOTLOADER in
    uboot) LOADER=uboot ;;
    sysdata) LOADER=uboot ;;
    grub) LOADER=grub ;;
    ?) LOADER=uboot ;;
esac

case $BOOTDEVICE in
    mmcblk0) DEVICE=mmc ;;
    mmcblk1) DEVICE=mmc ;;
    mmcblk2) DEVICE=mmc ;;
    sda) DEVICE=sda ;;
    ?) DEVICE=none ;;
esac

if [[ -z $LOADER ]]; then
    echo "Error: Invalid loader ($LOADER)"
fi

if [[ -z $DEVICE ]]; then
    echo "Error: Invalid device ($DEVICE)"
fi


echo "Checking for templates ..."

if [[ "$LOADER" != "grub" ]]; then
    if [[ ! -e ${FW_ENV_TEMPLATE} ]]; then
        echo "Error: Unable to find ${FW_ENV_TEMPLATE}"
        exit 1
    else
        echo "Found ${FW_ENV_TEMPLATE}"
    fi
fi

if [[ ! -e ${RAUC_TEMPLATE_DIR} ]]; then
    echo "Error: Unable to find ${RAUC_TEMPLATE_DIR}"
    exit 1
else
    echo "Found ${RAUC_TEMPLATE_DIR}"
fi

# Copy and edit RAUC configuration

echo "Configuration: RAUC"

cp ${RAUC_TEMPLATE_DIR}/${LOADER}.conf ${RAUC_CONFIG}
sed -i "s:<device>:${BOOTDEVICE}:g" ${RAUC_CONFIG}

# The sysdata interface requires a custom bootloader handler

if [ "$BOOTLOADER" == "sysdata" ]; then
    sed -i "s:bootloader=.*:bootloader=custom:" ${RAUC_CONFIG}
    printf "\n[handlers]" >> ${RAUC_CONFIG}
    printf "\nbootloader-custom-backend=/etc/rauc/sysdata_handler.sh" >> ${RAUC_CONFIG}
    printf "\npre-install=/etc/rauc/sysdata_pre_install.sh" >> ${RAUC_CONFIG}
    printf "\npost-install=/etc/rauc/sysdata_post_install.sh" >> ${RAUC_CONFIG}
    printf "\n" >> ${RAUC_CONFIG}
fi

if [[ "$LOADER" != "grub" ]]; then
   # Copy and alter fw-env configuration

   echo "Configuration: fw-env"

   cat $FW_ENV_TEMPLATE | grep ${DEVICE} > ${FW_ENV_CONFIG}
   sed -i "s:^<${DEVICE}> *::g" ${FW_ENV_CONFIG}
   sed -i "s:<device>:${BOOTDEVICE}:g" ${FW_ENV_CONFIG}
fi

echo "Finished"
