#!/bin/bash

for opt in $(cat /proc/cmdline); do
    arg=$(echo "$opt" | cut -d'=' -f1)
    if [ "$arg" == "bootloader" ]; then
        BOOTLOADER=$(echo "$opt" | cut -d'=' -f2-)
    elif [ "$arg" == "bootdevice" ]; then
        BOOTDEVICE=$(echo "$opt" | cut -d'=' -f2-)
    fi
done

# before start with the update procedure, the fail 
# boot counter is enabled

fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --set_boot_ok
ret=$?
if [[ $ret -ne 0 ]]; then
	exit $ret
fi

fw_sysdata --device /dev/${BOOTDEVICE} --target switchslot --fail_counter 0
ret=$?
if [[ $ret -ne 0 ]]; then
	exit $ret
fi

exit 0
