#!/bin/sh

echo ''
echo 'Apollo Lake BIOS updater - Linux 64 bit Version'
echo ''

if [ "$(id -u)" != "0" ]; then
   echo ''
   echo 'This script must be run as root'
   echo ''
   exit 1
fi

if ! [ -d "/usr/lib64" ]; then
  if ! [ -e "/lib64" ]; then
    echo "Create symbolc link to /lib64"
    ln -s /lib /lib64
  fi
fi


if [ -z "$1" ] || [ ! -f $1 ];then
  echo ''
  echo 'Please enter the BIOS file parameter : ./bios_updater_x64.sh official_bios.xxx '
  echo ''
  exit 1
fi
chmod +x EtaAfuOemLnx64
./EtaAfuOemLnx64 $1 /P /N /L /X
echo ''
echo 'Please reboot the system'
echo ''
